{      Source Code for TShareware component    V2.1  9/2/96       }
{            ** 16/32 bit versions -- for Delphi 1 **             }
{      By Dan English      --     Copyright 1996 RealSoft         }

{ Warning -- you are advised not to distribute any part of this   }
{ source code as users could easily "cheat" the system            }
{ You should distribute shareware components as .DCU files and    }
{ projects as .EXE's or DLL's                                     }

{Bug fixes & Updates:
{ 5/30/95 Fixed problem with OnRegister Event in procedure Execute       }
{ 6/08/96 Fixed problem with hidden files not being recognized by        }
{         FileExists() command -- countware & timerware was not updating }
{         if FileHide = true                                             }
{ 6/21/96 Added "Delphi IDE Only" option                                 }
{ 6/22/96 Modified and compiled for 32 bit version                       }
{ 7/25/96 Corrected problem with file not working if size = 32           }
{ 7/25/96 Made Register button invisible after registration              }
{ 9/01/96 Combined 16 & 32 bit versions into single file / split DCR's   }
{ 9/02/96 Built Dialog form into component so no separate DFM is needed  }
{ 9/07/96 Made Preview into a component editor and deleted AutoPreview pr}


{$DEFINE _DEMO}

unit Shware;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, Buttons, StdCtrls, DsgnIntf;

type

  {type definitions}
  TShareType     =   (stNagWare, stTimerWare, stCounterWare, stDelphi_IDE);
  TShareStatus   =   (ssUnRegistered, ssRegistered, ssExpired, ssTampered);

  {record definitions}
  RDiskFile      =   record
    Count    : LongInt;
    SDate    : TDateTime;
    MDate    : TDateTime;
    Reg      : TShareStatus;
    end;

  {Sub-property declaration}
  TBlock = class(TPersistent)
  private
    FLines       : TStrings;
    FColor       : TColor;
    FCtl3D       : Boolean;
    FFont        : TFont;
    FScrollBars  : TScrollStyle;
    FAlignment       : TAlignment;
    FBorderStyle : TBorderStyle;
    procedure SetLines(Value : TStrings);
    procedure SetFont (Value : TFont);
  protected
  public
    constructor Create;
    destructor Destroy; override;
  published
    property AlignmentText   : TAlignment         read FAlignment        write FAlignment;
    property Color       : TColor         read FColor        write FColor;
    property Ctl3D       : Boolean        read FCtl3D        write FCtl3D;
    property Font        : TFont          read FFont         write SetFont;
    property ScrollBars  : TScrollStyle   read FScrollBars   write FScrollBars;
    property Lines       : TStrings       read FLines        write SetLines;
    property BorderStyle : TBorderStyle   read FBorderStyle  write FBorderStyle;
  end;

  {Shareware class declaration}
  TShareWare = class(TComponent)
  private
    FShareType      :  TShareType;
    FShareStatus    :  TShareStatus;
    FMaxCount       :  LongInt;
    FMaxDays        :  LongInt;
    Fremaindays     :  LongInt;
    Fremaincount    :  LongInt;
    FEnabled        :  Boolean;
    FDisplayStatus  :  Boolean;
    FFileName       :  String;
    FFileSize       :  Word;
    FFileDate       :  String;
    FFileHide       :  Boolean;
    FPassword       :  String;
    FCaption        :  String;
    FFont           :  TFont;
    FColor          :  TColor;
    FSilentMode     :  Boolean;
    FDiskFile       : RDiskFile;
    {sub-properties}
    FBlockHeader    :  TBlock;
    FBlockInfo      :  TBlock;
    FBlockOrder     :  TBlock;
    {events}
    FOnBeforeShow   :  TNotifyEvent;
    FOnAfterShow    :  TNotifyEvent;
    FOnRegister     :  TNotifyEvent;
    {** Custom Shareware Dialog Components **}
    frmShare        : TForm;
    btnOK           : TButton;
    btnPass         : TButton;
    memoTitle       : TMemo;
    memoInfo        : TMemo;
    memoOrder       : TMemo;
    labStatus       : TLabel;
    procedure CreateDialog;
    procedure btnPassClick(Sender: TObject);
  protected
   procedure Loaded; override;
  public
   FPassEntry : String;
   constructor Create(AOwner: TComponent); override;
   destructor  Destroy; override;
   procedure Preview;
   procedure SetBlockHeader (Value: TBlock);
   procedure SetBlockInfo (Value: TBlock);
   procedure SetBlockOrder (Value: TBlock);
   procedure SetFont (Value : TFont);
   procedure SetDate (Value : String);
   procedure SetFileSize (Value : word);
   procedure SetMaxCount (Value: LongInt);
   function  GetDays(StartDate: TDateTime) : Real;
   function  UpdateFile(reg: boolean): smallint;
   procedure SetShare;
   procedure Execute;
   function DelphiRunning : boolean;
  published
   property BlockHeader    : TBlock        read FBlockHeader     write SetBlockHeader;
   property BlockInfo      : TBlock        read FBlockInfo       write SetBlockInfo;
   property BlockOrder     : TBlock        read FBlockOrder      write SetBlockOrder;
   property ShareType      : TShareType    read FShareType       write FShareType;
   property ShareStatus    : TShareStatus  read FShareStatus     write FShareStatus;
   property MaxCount       : LongInt       read FMaxCount        write SetMaxCount;
   property MaxDays        : LongInt       read FMaxDays         write FMaxDays;
   property RemainCount    : LongInt       read Fremaincount;    {read only}
   property RemainDays     : LongInt       read Fremaindays;     {read only}
   property Enabled        : Boolean       read FEnabled         write FEnabled;
   property DisplayStatus  : Boolean       read FDisplayStatus   write FDisplayStatus;
   property FileName       : String    read FFileName        write FFileName;
   property FileDate       : String    read FFileDate        write SetDate;
   property FileSize       : word          read FFileSize        write SetFileSize;
   property FileHide       : Boolean       read FFileHide        write FFileHide;
   property Password       : String    read FPassword        write FPassword;
   property Caption        : String    read FCaption         write FCaption;
   property Font           : TFont         read FFont            write SetFont;
   property Color          : TColor        read FColor           write FColor;
   property SilentMode     : Boolean       read FSilentMode      write FSilentMode;
   property OnBeforeShow   : TNotifyEvent  read FOnBeforeShow    write FOnBeforeShow;
   property OnAfterShow    : TNotifyEvent  read FOnAfterShow     write FOnAfterShow;
   property OnRegister     : TNotifyEvent  read FOnRegister      write FOnRegister;
  end;

  TSharewareEditor = class(TComponentEditor)
    function GetVerbCount : Integer; override;
    function GetVerb( Index : Integer ) : string; override;
    procedure ExecuteVerb( Index : Integer ); override;
    procedure Edit; override;
    end;

procedure Register;

implementation
{$IFDEF WIN32}
{$R *.R32}
{$ELSE}
{$R *.R16}
{$ENDIF}

procedure Register;
begin
 RegisterComponents('RealSoft', [TShareWare]);
 RegisterComponentEditor( TShareware, TSharewareEditor );
end;

{*************************************************************}
{                  Component Editor Section                   }
{*************************************************************}
function TShareWareEditor.GetVerbCount : Integer;
begin
  Result := 1;
end;

function TShareWareEditor.GetVerb( Index : Integer ) : string;
begin
  case Index of
    0: Result := '&Preview';
  end;
end;

procedure TShareWareEditor.ExecuteVerb( Index : Integer );
begin
  case index of
    0: Edit;
    end;
end;

procedure TShareWareEditor.Edit;
begin
  (Component as TShareWare).Preview;
end;

{*************************************************************}
{                    Heart of TShareWare                      }
{*************************************************************}
constructor TShareWare.Create( AOwner: TComponent );
begin
 inherited Create( AOwner );
   FBlockHeader  :=  TBlock.Create;
   FBlockInfo   :=  TBlock.Create;
   FBlockOrder  :=  TBlock.Create;
   FFont        :=  TFont.Create;
   {set defaults}
   FColor:= clSilver;
   FFont.Name:= 'MS Sans Serif';
   FDisplayStatus:= true;
   FCaption:= 'Shareware Notice';
   FMaxDays:= 30;
   FMaxCount:= 5;
   Fremaindays:= 30;
   Fremaincount:= 5;
   FPassEntry:= '';
   FPassWord:= '';
   FEnabled:= true;
   FShareStatus:= ssUnRegistered;
   FSilentMode:= false;
   FShareType:= stNagware;
   FFileName:= '';
   FFileHide:= false;

   FDiskFile.Count:=  5;
   FDiskFile.Reg:= ssUnRegistered;
   FDiskFile.SDate:= Date;
   FDiskFile.MDate:= Date;

   FBlockHeader.Fcolor:= clSilver;
   FBlockHeader.FFont.Name:= 'MS Sans Serif';
   FBlockHeader.FFont.Style:= [fsBold];
   FBlockHeader.FLines.Clear;
   FBlockHeader.FLines.Add('* A Great Program *');
   FBlockHeader.FLines.Add('(Demo Version)');
   FBlockHeader.FFont.Size:= 12;
   FBlockHeader.FAlignment:= taCenter;

   FBlockInfo.Fcolor:= clWhite;
   FBlockInfo.FCtl3d:= true;
   FBlockInfo.FBorderStyle:= bsSingle;
   FBlockInfo.FFont.Name:= 'MS Sans Serif';
   FBlockinfo.FScrollBars:= ssVertical;
   FBlockinfo.FAlignment:= taLeftJustify;
   FBlockInfo.FLines.Clear;
   FBlockInfo.FLines.Add('   This program is Shareware!');
   FBlockInfo.FLines.Add('');
   FBlockInfo.FLines.Add('   If you find this program useful, you are strongly');
   FBlockInfo.FLines.Add('   encouraged to register this product.');
   FBlockInfo.FLines.Add('');
   FBlockInfo.FLines.Add('   As a registered user, you will receive a complete');
   FBlockInfo.FLines.Add('   manual, technical support for the product,  and free');
   FBlockInfo.FLines.Add('   updates to the program.');
   FBlockInfo.FLines.Add('');
   FBlockInfo.FLines.Add('   By registering this program, we will be able to continue');
   FBlockInfo.FLines.Add('   to create new and exciting programs in the future.');
   FBlockInfo.FLines.Add('   Thanks for your support!');

   FBlockOrder.Fcolor:= clNavy;
   FBlockOrder.FCtl3d:= true;
   FBlockOrder.FFont.Name:= 'MS Sans Serif';
   FBlockOrder.FFont.Color:= clAqua;
   FBlockOrder.FAlignment:= taLeftJustify;
   FBlockOrder.FLines.Clear;
   FBlockOrder.FLines.Add('        To order this product, please contact our web site at');
   FBlockOrder.FLines.Add('        www.anyweb.com or send $19.95 payable in US funds to:');
   FBlockOrder.FLines.Add('');
   FBlockOrder.FLines.Add('                A Great Company');
   FBlockOrder.FLines.Add('                123 Main Street');
   FBlockOrder.FLines.Add('                AnyTown, Ca 92678');

end;

procedure TShareWare.Loaded;
begin
   inherited Loaded;
   {set default values}
   Fremaindays:= FMaxDays;
   Fremaincount:= FMaxCount;
   {update values from disk file}
   if not (csDesigning in ComponentState) then UpdateFile(false);
   {$IFDEF DEMO}
   if not DelphiRunning then
     showmessage('This program is using an unregistered version of the TShareWare' + #13 +
                 'component from RealSoft.  Please register on Compuserve, or call' + #13 +
                 'RealSoft at (714) 831-7879.');
   {$ENDIF}
end;

destructor TShareWare.Destroy;
begin
   FBlockHeader.Free;
   FBlockInfo.Free;
   FBlockOrder.Free;
   FFont.Free;
   inherited Destroy;
end;

procedure TShareWare.Execute;
begin
 if enabled = true then begin
   if Assigned(FOnBeforeShow) then OnBeforeShow(Self);  {event}

   CreateDialog;
   SetShare;
   btnPASS.enabled:= true;
   if (not FSilentMode) then begin
     if (fShareType = stDelphi_Ide) then begin
       if not DelphiRunning then frmShare.ShowModal;
       end
     else frmShare.ShowModal;
     end;
   frmShare.Free;

   if Assigned(FOnAfterShow) then OnAfterShow(Self);    {event}
   {password registration}
   if FPassEntry <> '' then begin
     if FPassEntry = FPassWord then begin
       FShareStatus:= ssRegistered;
       UpdateFile(true); {register with file}
       FPassEntry:= '';
       MessageDlg('Password accepted -- Your software is registered.',mtConfirmation,[mbOk],0);
       if Assigned(FOnRegister) then OnRegister(Self); {event}
       end
     else MessageDlg('Password denied -- Please try again.',mtConfirmation,[mbOk],0);
     end;
  end;
end;

procedure TShareWare.Preview;
begin
  CreateDialog;
  SetShare;
  btnPASS.enabled:= false;
  frmShare.ShowModal;
  frmShare.Free;
end;

procedure TShareWare.SetBlockHeader (Value: TBlock);
begin
FBlockHeader.Assign(Value);
end;
procedure TShareWare.SetBlockInfo (Value: TBlock);
begin
FBlockInfo.Assign(Value);
end;
procedure TShareWare.SetBlockOrder (Value: TBlock);
begin
FBlockOrder.Assign(Value);
end;

procedure TShareWare.SetFont (Value : TFont);
begin
FFont.Assign(Value);
end;

procedure TShareWare.SetDate (Value : String);
var dt: TDateTime;
begin
if (Value <> FFileDate) and (Value <> '') then begin
  try
    dt:= StrtoDate(Value);
  except
    on EConvertError do begin
      MessageDlg(Value + ' is not a valid date!', mtError,[mbok],0);
      Value := '';
      end;
    end;
  FFileDate:= Value;
  end;
end;

procedure TShareWare.SetFileSize (Value : word);
begin
if FFileSize <> Value then begin
  if (Value < 32) or (Value > 32000) then begin
    MessageDlg('File Size must be between 32 and 32000',mtWarning,[mbok],0);
    FFilesize:= 0;
    end
  else FFileSize:= Value;
  end;
end;

procedure TShareWare.SetMaxCount (Value : LongInt);
begin
if FMaxCount <> Value then begin
  FMaxCount:= Value;
  FDiskFile.Count:= Value;
  end;
end;

function  TShareWare.GetDays(StartDate: TDateTime) : Real;
begin
  {return days left since installation}
  result:= FMaxDays - (Date - StartDate);
  if result < 0 then result:= 0;
end;

function TShareWare.UpdateFile(reg: boolean) : smallint;
var handle,i  : smallint;
    filemode  : word;
    tmpstr    : String;
    tmpchr    : array[0..255] of char;
    dt        : TDateTime;
    dl        : LongInt;
    buffer    : Pointer;
begin
 {create disk status file or read existing}
 if (FFilename <> '') and (FFilesize > 31) and (ShareType <> stNagWare) then begin
   try
     GetMem(buffer, FFileSize);
     {create path}
     GetWindowsDirectory(tmpchr, 255);
     tmpstr:= StrPas(tmpchr) + '\' + FFileName;
     { unhide to see if file exists}
     {$I-}
     FileSetAttr(tmpstr,0);
     {$I+}
     if not FileExists(tmpstr) then begin
        {place data in buffer}
        FDiskFile.Count:= FMaxCount;  {put count in}
        FDiskFile.SDate:= Date;     {put in start date}
        FDiskFile.MDate:= Date;     {put in master date}
        FDiskFile.Reg:= ssUnRegistered;
        move(FDiskFile, buffer^, sizeof(FDiskFile));
        {create file}
        handle:= FileCreate(tmpstr);
        if handle > 0 then begin
          {write to file}
          FileWrite(handle, buffer^, FFileSize);
          {change date}
          if FFileDate <> '' then begin
            dt:= StrtoDate(FFileDate) + time;
            dl:= DateTimetoFileDate(dt);
            FileSetDate(handle,dl);
            end;
          FileClose(handle);
          {assign attribute}
          if FFileHide then FileSetAttr(tmpstr,faHidden)
          else FileSetAttr(tmpstr, 0);
          end;
        end
     else begin     {file exists -- check status         }
       {re-hide if necessary}
       if FFileHide then FileSetAttr(tmpstr,faHidden);
       {open file}
       filemode:= fmOpenReadWrite;
       handle:= FileOpen(tmpstr, filemode);
       if handle > 0 then begin
         {read from file}
         FileRead(handle, buffer^, FFileSize);
         move(buffer^, FDiskFile, sizeof(FDiskFile));
         {update read-only properties}
         tmpstr:= floattostrf(GetDays(FDiskFile.SDate),ffGeneral,0,0);
         try
          Fremaindays:= strtoint(tmpstr);
         except on EconvertError do Fremaindays:= FMaxDays;
         end;
         Fremaincount:= FDiskFile.Count;
         {register?}
         if reg then FDiskFile.Reg:= ssRegistered
         else FShareStatus := FDiskFile.Reg;
         {counterware}
         if (FShareType = stCounterware) and (FShareStatus = ssUnRegistered) then begin
           dec(FDiskFile.Count);
           if FDiskFile.Count < 1 then begin
             FShareStatus:= ssExpired;
             FDiskFile.Count:= 0;
             end;
           end;
         {Timerware}
         if (FShareType = stTimerWare) and (FShareStatus = ssUnRegistered) then begin
           {check master date for tampering}
           if Date < FDiskFile.MDate then FShareStatus:= ssTampered
           else begin
             FDiskFile.MDate:= Date;
             FShareStatus:= ssUnRegistered;
             {check if expired}
             if GetDays(FDiskFile.SDate) < 1 then FShareStatus:= ssExpired;
             end;
           end;
         {write changes to file}
         move(FDiskFile, buffer^, sizeof(FDiskFile));
         FileSeek(handle,0,0);
         FileWrite(handle, buffer^, FFileSize);
         {change date}
         if FFileDate <> '' then begin
            dt:= StrtoDate(FFileDate) + time;
            dl:= DateTimetoFileDate(dt);
            FileSetDate(handle,dl);
            end;
         FileClose(handle);
         end;
       end;
   finally
     FreeMem(buffer, FFileSize);
     end; {try}
   end;
end;

procedure TShareWare.SetShare;
var days : real;
begin
 {setup popup dialog}
 {memos                      }
 MemoTitle.Lines.Assign(FBlockHeader.FLines);
 MemoInfo.Lines.Assign(FBlockInfo.FLines);
 MemoOrder.Lines.Assign(FBlockOrder.FLines);
 {fonts}
 MemoTitle.Font:= FBlockHeader.FFont;
 MemoInfo.Font:= FBlockInfo.FFont;
 MemoOrder.Font:= FBlockOrder.FFont;
 {Colors}
 MemoTitle.Color:= FBlockHeader.FColor;
 MemoInfo.Color:= FBlockInfo.FColor;
 MemoOrder.Color:= FBlockOrder.FColor;
 {Control 3D}
 MemoTitle.Ctl3D:= FBlockHeader.FCtl3D;
 MemoInfo.Ctl3D:= FBlockInfo.FCtl3D;
 MemoOrder.Ctl3D:= FBlockOrder.FCtl3D;
 {ScrollBars}
 MemoTitle.ScrollBars:= FBlockHeader.FScrollBars;
 MemoInfo.ScrollBars:= FBlockInfo.FScrollBars;
 MemoOrder.ScrollBars:= FBlockOrder.FScrollBars;
 {Alignment}
 MemoTitle.Alignment:= FBlockHeader.FAlignment;
 MemoInfo.Alignment:= FBlockInfo.FAlignment;
 MemoOrder.Alignment:= FBlockOrder.FAlignment;
 {BorderStyle}
 MemoTitle.BorderStyle:= FBlockHeader.FBorderStyle;
 MemoInfo.BorderStyle:= FBlockInfo.FBorderStyle;
 MemoOrder.BorderStyle:= FBlockOrder.FBorderStyle;
 { form itself                  }
 frmShare.Color:= FColor;
 frmShare.Font.Assign(FFont);
 frmShare.Caption:= FCaption;
 {password button}
 if (FPassword <> '') and (FShareStatus <> ssRegistered) then btnPASS.visible:= true
 else btnPASS.visible:= false;
 {Status label}
 if FDisplayStatus = true then begin
   {Registered}
   if FShareStatus = ssRegistered then labStatus.caption:= 'This software has been registered.';
   {expired}
   if FShareStatus = ssExpired then labStatus.caption:= 'Your trial period has expired.  Please register!';
   {tampered system date}
   if FShareStatus = ssTampered then labStatus.caption:= 'System Date has been modified.  Please register!';
   {unregistered}
   if FShareStatus = ssUnRegistered then begin
     {nagware}
     if FShareType = stNagware then labStatus.caption:= 'This software has not been registered.';
     {timerware}
     if FShareType = stTimerware then begin
        days:= GetDays(FDiskFile.SDate);
        if days > 1 then labStatus.caption:= 'Your trial period for this software will end in '
                         + floattostrf(days,ffGeneral,0,0) +' days.';
        if days = 1 then labStatus.caption:= 'Your trial period for this software will end in 1 day.';
        if days < 1 then labStatus.caption:= 'Your trial time has expired.  Please register.';
        end;
     {counterware}
     if FShareType = stCounterWare then begin
        if FDiskFile.Count > 1 then labStatus.caption:= 'You can use this trial software '
                                    + inttostr(FDiskFile.Count) +' more times.';
        if FDiskFile.Count = 1 then labStatus.caption:= 'You can use this trial software 1 more time.';
        if FDiskFile.Count < 1 then labStatus.caption:= 'Your trial use has expired.  Please register!';
        end;
     {Runs in Delphi IDE Only}
     if FShareType = stDelphi_IDE then begin
       if not DelphiRunning then
         labStatus.caption:= 'This software will only run in the Delphi IDE until registered.';
       end;
     end;
   end
 else labStatus.caption:= '';
end;


{TBLOCK  -- Sub properties   }
constructor TBlock.Create;
begin
 inherited Create;
 FLines   :=   TStringList.Create;
 FFont    :=   TFont.Create;
end;

destructor TBlock.Destroy;
begin
 FFont.Free;
 FLines.Free;
 inherited Destroy;
end;

procedure TBlock.SetLines(Value : TStrings);
begin
 FLines.Assign(Value);
end;

procedure TBlock.SetFont (Value : TFont);
begin
 FFont.Assign(Value);
end;

function TShareWare.DelphiRunning : boolean;
begin
 if((FindWindow('TApplication','Delphi') = 0) and (FindWindow('TApplication','Delphi 2.0') = 0) ) or
   (FindWindow('TPropertyInspector',nil) = 0) or
   (FindWindow('TAppBuilder',nil) = 0) then result:= false
 else result:= true;
end;

{** Special Dialog Form **}

procedure TShareWare.CreateDialog;
begin
  {Create Form *on the fly* }
  frmShare        := TForm.CreateNew(Application);
  {Create Components}
  btnOK           := TButton.Create(frmShare);
  btnPass         := TButton.Create(frmShare);
  memoTitle       := TMemo.Create(frmShare);
  memoInfo        := TMemo.Create(frmShare);
  memoOrder       := TMemo.Create(frmShare);
  labStatus       := TLabel.Create(frmShare);
  {Set properties since we have no .DFM file}
  frmShare.Left := 275;
  frmShare.Top := 104;
  frmShare.HorzScrollBar.Visible:= False;
  frmShare.VertScrollBar.Visible:= False;
  frmShare.BorderIcons:= [biSystemMenu];
  frmShare.BorderStyle:= bsDialog;
  frmShare.Caption:= 'ShareWare';
  frmShare.ClientHeight:= 398;
  frmShare.ClientWidth:= 392;
  frmShare.Font.Color:= clBlack;
  frmShare.Font.Height:= -13;
  frmShare.Font.Name:= 'MS Sans Serif';
  frmShare.Font.Style:= [];
  frmShare.PixelsPerInch:= 96;
  frmShare.Position:= poScreenCenter;
  frmShare.Visible:= false;

  labStatus.Parent:= frmShare;
  labStatus.Left:= 8;
  labStatus.Top:= 345;
  labStatus.Width:= 385;
  labStatus.Height:= 16;

  btnOk.Parent:= frmShare;
  btnOK.Left:= 296;
  btnOK.Top:= 368;
  btnOK.Width:= 89;
  btnOK.Height:= 25;
  btnOK.Caption:= '&OK';
  btnOK.ModalResult:= 1;
  btnOK.TabOrder:= 0;

  btnPass.Parent:= frmShare;
  btnPass.Left:= 200;
  btnPass.Top:= 368;
  btnPass.Width:= 89;
  btnPass.Height:= 25;
  btnPass.Caption:= '&Register';
  btnPass.ModalResult:= 6;
  btnPass.TabOrder:= 1;
  btnPass.OnClick:= btnPassClick; {event}

  memoTitle.Parent:= frmShare;
  memoTitle.Left:= 1;
  memoTitle.Top:= 6;
  memoTitle.Width:= 390;
  memoTitle.Height:= 51;
  memoTitle.Alignment:= taCenter;
  memoTitle.BorderStyle:= bsNone;
  memoTitle.Color:= clBtnFace;
  memoTitle.Ctl3D:= True;
  memoTitle.ParentCtl3D:= False;
  memoTitle.ReadOnly:= True;
  memoTitle.TabOrder:= 2;

  memoInfo.Parent:= frmShare;
  memoInfo.Left:= 1;
  memoInfo.Top:= 64;
  memoInfo.Width:= 390;
  memoInfo.Height:= 149;
  memoInfo.Alignment:= taCenter;
  memoInfo.BorderStyle:= bsNone;
  memoInfo.Color:= clBtnFace;
  memoInfo.Ctl3D:= True;
  memoInfo.ParentCtl3D:= False;
  memoInfo.ReadOnly:= True;
  memoInfo.TabOrder:= 3;

  memoOrder.Parent:= frmShare;
  memoOrder.Left:= 1;
  memoOrder.Top:= 224;
  memoOrder.Width:= 390;
  memoOrder.Height:= 111;
  memoOrder.Alignment:= taCenter;
  memoOrder.BorderStyle:= bsNone;
  memoOrder.Color:= clBtnFace;
  memoOrder.Ctl3D:= True;
  memoOrder.ParentCtl3D:= False;
  memoOrder.ReadOnly:= True;
  memoOrder.TabOrder:= 4;
end;

procedure TShareWare.btnPassClick(Sender: TObject);
var
  NewString: String;
  ClickedOK: Boolean;
begin
  NewString := '';
  ClickedOK := InputQuery('Password Registration', 'Enter Password:', NewString);
  if ClickedOK then FPassEntry:= NewString
  else FPassEntry:= '';
end;

end.
